/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.toma.gunsrpg.util.Identifiable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public final class SimpleRegistry<V extends Identifiable>
implements Codec<V> {
    private final String registryName;
    private final Map<ResourceLocation, V> map = new HashMap<ResourceLocation, V>();

    public SimpleRegistry(String registryName) {
        this.registryName = Objects.requireNonNull(registryName);
    }

    public synchronized void register(V value) {
        ResourceLocation key = Objects.requireNonNull(value.getIdentifier());
        if (this.map.put(key, value) != null) {
            throw new IllegalArgumentException("Duplicate registry key: " + key + " for registry " + this.registryName);
        }
    }

    public V get(ResourceLocation key) {
        return (V)((Identifiable)this.map.get(key));
    }

    public <T> T getGeneric(ResourceLocation key) {
        return (T)this.map.get(key);
    }

    public Optional<V> getOptional(ResourceLocation key) {
        return Optional.ofNullable(this.get(key));
    }

    public <T> Optional<T> getGenericOptional(ResourceLocation key) {
        return Optional.ofNullable(this.getGeneric(key));
    }

    public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
        ResourceLocation key = input.getIdentifier();
        if (key == null) {
            return DataResult.error((String)("Missing key for object " + input));
        }
        return ops.mergeToPrimitive(prefix, ops.createString(key.toString()));
    }

    public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
        return ResourceLocation.field_240908_a_.decode(ops, input).flatMap(pair -> {
            V value = this.get((ResourceLocation)pair.getFirst());
            return value != null ? DataResult.success((Object)Pair.of(value, (Object)pair.getSecond())) : DataResult.error((String)("Unknown " + this.registryName + " key " + pair.getFirst()));
        });
    }
}

